/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.Accumulator;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class ASL
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        int value = (int)operand.getByte().getNumber();
        Flags6502 flags = cpu.getFlags();
        flags.setCarry((value <<= 1) > 255);
        flags.setNZFromValue(value &= 0xFF);
        operand.setByte(new HwByte((long)value));
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "ASL";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(10, this, new Accumulator());
        cset.defineCommand(6, this, new ZeroPage(), 4);
        cset.defineCommand(22, this, new ZeroPageX(), 4);
        cset.defineCommand(14, this, new Absolute(), 4);
        cset.defineCommand(30, this, new AbsoluteX(false), 5);
    }
}

